import objc
from Foundation import *
from AppKit import *
import sys
import sqlite3
import struct
import os.path

def scribbleDecode(sdata):
	sptr = 0x24
	lines = []
	while sptr<len(sdata)-10:
		hdr = struct.unpack_from("IIIIIII", sdata, sptr)
		brushsize = hdr[5]
		numpoints = hdr[6]
		print hdr
		sptr += 24
		oldpt = None
		for i in range(numpoints):
			spt = struct.unpack_from("III", sdata, sptr)
			x = spt[1]
			y = spt[2]
			newpt = (x,y)
			sptr += 12
			if oldpt:
				lines.append((oldpt,newpt, brushsize))
				oldpt = newpt
			else:
				oldpt = newpt
	return lines

class MetaDB:
	def __init__(self, fn):
		print "loading db:", fn
		self.dbconn = sqlite3.connect(fn)
		self.dbconn.row_factory = sqlite3.Row
		self.dbcurs = self.dbconn.cursor()

	def getAnnotationsForFile(self, fn, anntype):
		self.dbcurs.execute("select * from file_metadata where filename='%s'" % fn)
		res = self.dbcurs.fetchone()
		if res:
			query = "select * from annotations where file_id='%s' and annotation_type='%s'"
			self.dbcurs.execute(query % (res["file_id"], anntype))
			return self.dbcurs.fetchall()
		return None
		
class DRMergeController(NSObject):
	@objc.IBAction
	def merge_(self,sender):
		panel = NSOpenPanel.openPanel()
		panel.setCanChooseDirectories_(False)
		panel.setAllowsMultipleSelection_(False)
		ret_value = panel.runModalForTypes_(('pdf',))
		if ret_value:
			self.doMerge(panel.filenames()[0])

	def showError(self, message):
		alert = NSAlert.alloc().init()
		alert.addButtonWithTitle_("OK")
		alert.setMessageText_("Merge Error")
		alert.setInformativeText_(message)
		alert.setAlertStyle_(NSWarningAlertStyle)
		alert.runModal()
		
	def showInfo(self, message):
		alert = NSAlert.alloc().init()
		alert.addButtonWithTitle_("OK")
		alert.setMessageText_("Merge Complete")
		alert.setInformativeText_(message)
		alert.setAlertStyle_(NSInformationalAlertStyle)
		alert.runModal()
			
	def doMerge(self, filename):
		import Quartz
		dir = os.path.dirname(filename)
		url = NSURL.fileURLWithPath_(filename)
		pdfDoc = Quartz.PDFDocument.alloc().initWithURL_(url)

		mdb = MetaDB(dir+"/metadata.db")

		scribbles = mdb.getAnnotationsForFile(os.path.basename(filename),"scribble")
		if not scribbles:
			self.showError("No scribbles or file not in metadb")
			return
			
		for scb in scribbles:
			lines = scribbleDecode(scb["data"])
			anchor = scb["start_anchor"]
			if "pdf:/page:" in anchor:
				pn = int(anchor.split(":")[-1])
				page = pdfDoc.pageAtIndex_(pn-1)
				bounds = page.boundsForBox_(Quartz.kPDFDisplayBoxArtBox)
				oldsize = None
				scalex = 0.8/bounds[1][0]
				scaley = 0.8/bounds[1][1]
				for l in lines:
					if oldsize!=l[2]:
						oldsize=l[2]
						border = Quartz.PDFBorder.alloc().init()
						border.setLineWidth_(0.001 * l[2])
					sx = l[0][1]*scalex
					sy = l[0][0]*scaley
					ex = l[1][1]*scalex
					ey = l[1][0]*scaley
					pdfline = Quartz.PDFAnnotationLine.alloc().initWithBounds_(bounds)
					pdfline.setBorder_(border)
					pdfline.setStartPoint_((sx,sy))
					pdfline.setEndPoint_((ex,ey))
					page.addAnnotation_(pdfline)
			else:
				self.showError("Unknown anchor '%s'" % anchor)
				return

		tofile = ".".join(filename.split(".")[:-1])+"_merged.pdf"
		pdfDoc.writeToFile_(tofile)
		self.showInfo("%d scribbles merged to %s" % (len(scribbles), tofile))
				
